<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'number', 'password');
    protected $hidden = array('password');

    public function restaurants_reviews()
    {
        return $this->hasMany('App\Models\RestaurantReview');
    }

    public function products_reviews()
    {
        return $this->hasMany('App\Models\ProductReview');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}